/*
 * Decompiled with CFR 0.152.
 */
package org.gicentre.utils.network.traer.physics;

import org.gicentre.utils.network.traer.physics.Integrator;
import org.gicentre.utils.network.traer.physics.Particle;
import org.gicentre.utils.network.traer.physics.ParticleSystem;
import org.gicentre.utils.network.traer.physics.Vector3D;

public class BackwardEulerIntegrator
extends Integrator {
    public BackwardEulerIntegrator(ParticleSystem s) {
        super(s);
    }

    public BackwardEulerIntegrator step(float deltaT) {
        this.s.clearForces();
        this.s.applyForces();
        for (Particle p : this.s.getParticles()) {
            if (!p.isFree()) continue;
            p.velocity().add(p.getForce().multiplyBy(deltaT / p.mass()));
            p.position().add(Vector3D.multiplyBy(p.velocity(), deltaT));
        }
        return this;
    }
}

