/*
 * Decompiled with CFR 0.152.
 */
package org.gicentre.utils.network.traer.physics;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gicentre.utils.network.traer.physics.AbstractForce;
import org.gicentre.utils.network.traer.physics.Attraction;
import org.gicentre.utils.network.traer.physics.Integrator;
import org.gicentre.utils.network.traer.physics.Particle;
import org.gicentre.utils.network.traer.physics.Spring;
import org.gicentre.utils.network.traer.physics.Vector3D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParticleSystem {
    @Deprecated
    public static final int RUNGE_KUTTA = Integrator.METHOD.RUNGEKUTTA.ordinal();
    @Deprecated
    public static final int MODIFIED_EULER = Integrator.METHOD.MODEULER.ordinal();
    protected static final float DEFAULT_DRAG = 0.001f;
    protected static final float DEFAULT_GRAVITY = 0.0f;
    private Set<Particle> particles = new LinkedHashSet<Particle>();
    private Set<Spring> springs = new LinkedHashSet<Spring>();
    private Set<Attraction> attractions = new LinkedHashSet<Attraction>();
    private Set<AbstractForce> customForces = new LinkedHashSet<AbstractForce>();
    private float deltaT = 1.0f;
    private Integrator integrator;
    private Vector3D gravity;
    private float drag;

    public ParticleSystem() {
        this(0.0f, 0.001f);
    }

    public ParticleSystem(float g, float drag) {
        this(0.0f, g, 0.0f, drag);
    }

    public ParticleSystem(float gx, float gy, float gz, float drag) {
        this.setIntegrator(Integrator.METHOD.RUNGEKUTTA);
        this.gravity = new Vector3D(gx, gy, gz);
        this.setDrag(drag);
    }

    public final ParticleSystem setDeltaT(float t) throws IllegalArgumentException {
        if (t <= 0.0f) {
            throw new IllegalArgumentException("Argument t is " + t + "; t must be >=0.");
        }
        this.deltaT = t;
        return this;
    }

    public final float getDeltaT() {
        return this.deltaT;
    }

    public final ParticleSystem tick() {
        return this.tick(this.deltaT);
    }

    public final ParticleSystem tick(float t) {
        if (t <= 0.0f) {
            throw new IllegalArgumentException("Argument t is " + t + "; t must be >=0.");
        }
        this.integrator.step(t);
        return this;
    }

    @Deprecated
    public final ParticleSystem setIntegrator(int integrator) throws IllegalArgumentException {
        try {
            return this.setIntegrator(Integrator.METHOD.values()[integrator]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return ParticleSystem.illegalArgThrower("Argument integrator does not correspond to a valid Integrator; consult Integrator class for valid options.");
        }
    }

    public final ParticleSystem setIntegrator(Integrator.METHOD integrator) {
        return this.setIntegrator(integrator.factory(this));
    }

    public final ParticleSystem setIntegrator(Integrator integrator) throws NullPointerException {
        ParticleSystem.nullThrower(integrator, "Argument integrator is null in setIntegrator(integrator) call.");
        this.integrator = integrator;
        return this;
    }

    public final ParticleSystem setGravity(float x, float y, float z) {
        this.gravity.set(x, y, z);
        return this;
    }

    public final ParticleSystem setGravity(float g) {
        return this.setGravity(0.0f, g, 0.0f);
    }

    public final ParticleSystem setDrag(float d) {
        this.drag = d;
        return this;
    }

    public final Particle makeParticle(float mass, float x, float y, float z) {
        Particle p = new Particle(mass);
        p.position().set(x, y, z);
        this.particles.add(p);
        return p;
    }

    public final Particle makeParticle() {
        Particle p = new Particle();
        this.particles.add(p);
        return p;
    }

    public final Particle makeParticle(Particle p) {
        ParticleSystem.nullThrower(p, "Argument p is null in makeParticle(p) call.");
        this.particles.add(p);
        return p;
    }

    public final Spring makeSpring(Particle a, Particle b, float strength, float damping, float restLength) throws NullPointerException {
        if (a.equals(b)) {
            return null;
        }
        Spring s = new Spring(a, b, strength, damping, restLength);
        this.springs.add(s);
        return s;
    }

    public final Attraction makeAttraction(Particle a, Particle b, float strength, float minDistance) throws NullPointerException {
        if (a.equals(b)) {
            return null;
        }
        Attraction m = new Attraction(a, b, strength, minDistance);
        this.attractions.add(m);
        return m;
    }

    @Deprecated
    public final Collection<Spring> springs() {
        return this.getSprings();
    }

    public final Collection<Spring> getSprings() {
        return this.springs;
    }

    @Deprecated
    public final int numberOfSprings() {
        return this.getNumSprings();
    }

    public final int getNumSprings() {
        return this.springs.size();
    }

    public final Spring getSpring(int i) {
        int counter = 0;
        Spring spring2 = null;
        for (Spring spring2 : this.springs) {
            if (counter == i) break;
            ++counter;
        }
        return spring2;
    }

    public final Spring removeSpring(int i) {
        int counter = 0;
        Spring spring = null;
        Iterator<Spring> it = this.springs.iterator();
        while (it.hasNext()) {
            spring = it.next();
            if (counter == i) {
                it.remove();
                return spring;
            }
            ++counter;
        }
        return null;
    }

    public final ParticleSystem removeSpring(Spring spring) {
        this.springs.remove(spring);
        return this;
    }

    @Deprecated
    public final Collection<Attraction> attractions() {
        return this.attractions;
    }

    public final Collection<Attraction> getAttractions() {
        return this.attractions;
    }

    @Deprecated
    public final int numberOfAttractions() {
        return this.getNumAttractions();
    }

    public final int getNumAttractions() {
        return this.attractions.size();
    }

    public final Attraction getAttraction(int i) {
        int counter = 0;
        Attraction attraction2 = null;
        for (Attraction attraction2 : this.attractions) {
            if (counter == i) break;
            ++counter;
        }
        return attraction2;
    }

    public final Attraction removeAttraction(int i) {
        int counter = 0;
        Attraction attraction = null;
        Iterator<Attraction> it = this.attractions.iterator();
        while (it.hasNext()) {
            attraction = it.next();
            if (counter == i) {
                it.remove();
                return attraction;
            }
            ++counter;
        }
        return null;
    }

    public final ParticleSystem removeAttraction(Attraction attraction) {
        this.attractions.remove(attraction);
        return this;
    }

    @Deprecated
    public final Collection<AbstractForce> customForces() {
        return this.getCustomForces();
    }

    public final Collection<AbstractForce> getCustomForces() {
        return this.customForces;
    }

    public final ParticleSystem addCustomForce(AbstractForce customForce) {
        if (customForce != null) {
            this.customForces.add(customForce);
        }
        return this;
    }

    @Deprecated
    public final int numberOfCustomForces() {
        return this.getNumCustomForces();
    }

    public final int getNumCustomForces() {
        return this.customForces.size();
    }

    public final AbstractForce getCustomForce(int i) {
        int counter = 0;
        AbstractForce force2 = null;
        for (AbstractForce force2 : this.customForces) {
            if (counter == i) break;
            ++counter;
        }
        return force2;
    }

    public final AbstractForce removeCustomForce(int i) {
        int counter = 0;
        AbstractForce force = null;
        Iterator<AbstractForce> it = this.customForces.iterator();
        while (it.hasNext()) {
            force = it.next();
            if (counter == i) {
                it.remove();
                return force;
            }
            ++counter;
        }
        return null;
    }

    public final ParticleSystem removeCustomForce(AbstractForce customForce) {
        this.customForces.remove(customForce);
        return this;
    }

    @Deprecated
    public final Collection<Particle> particles() {
        return this.getParticles();
    }

    public final Collection<Particle> getParticles() {
        return this.particles;
    }

    @Deprecated
    public final int numberOfParticles() {
        return this.getNumParticles();
    }

    public final int getNumParticles() {
        return this.particles.size();
    }

    public final Particle getParticle(int i) {
        int counter = 0;
        Particle p2 = null;
        for (Particle p2 : this.particles) {
            if (counter == i) break;
            ++counter;
        }
        return p2;
    }

    public final ParticleSystem removeParticle(Particle p) {
        this.particles.remove(p);
        return this;
    }

    public final void clear() {
        this.particles.clear();
        this.springs.clear();
        this.attractions.clear();
        this.customForces.clear();
    }

    protected final void applyForces() {
        if (!this.gravity.isZero()) {
            for (Particle particle : this.getParticles()) {
                particle.addForce(this.gravity).addForce(Vector3D.multiplyBy(particle.velocity(), -this.drag));
            }
        } else {
            for (Particle particle : this.getParticles()) {
                particle.addForce(Vector3D.multiplyBy(particle.velocity(), -this.drag));
            }
        }
        for (Spring spring : this.getSprings()) {
            spring.apply();
        }
        for (Attraction attraction : this.getAttractions()) {
            attraction.apply();
        }
        for (AbstractForce abstractForce : this.getCustomForces()) {
            abstractForce.apply();
        }
    }

    protected final void clearForces() {
        for (Particle p : this.particles) {
            p.clearForce();
        }
    }

    public final void clearAllForces() {
        this.clearForces();
        this.springs.clear();
        this.attractions.clear();
        this.customForces.clear();
    }

    private static final void nullThrower(Object o, String message) throws NullPointerException {
        if (o == null) {
            throw new NullPointerException(message);
        }
    }

    private static final ParticleSystem illegalArgThrower(String message) {
        throw new IllegalArgumentException(message);
    }
}

