/*
 * Decompiled with CFR 0.152.
 */
package org.gicentre.utils.spatial;

import org.gicentre.utils.spatial.Ellipsoid;
import org.gicentre.utils.spatial.MapProjection;
import processing.core.PVector;

public class FrenchNTF
implements MapProjection {
    public static final int FROM_LAT_LONG = 1;
    public static final int TO_LAT_LONG = 2;
    private static final double RAD2DEG = 57.29577951308232;
    private static final double DEG2RAD = Math.PI / 180;
    private static final double PI_OVER_2 = 1.5707963267948966;
    private static final double PI_OVER_4 = 0.7853981633974483;
    private static final int ZONE_I = 1;
    private static final int ZONE_II = 2;
    private static final int ZONE_III = 3;
    private static final int ZONE_IV = 4;
    private static final int ZONE_IIe = 5;
    private double latOrigin;
    private double lngOrigin;
    private double phi1;
    private double phi2;
    private double falseEasting;
    private double falseNorthing;
    private double es;
    private double esOver2;
    private double aF;
    private double n;
    private double rho0;
    private int direction;
    private int zone;
    private Ellipsoid clarke1880;
    private Ellipsoid wgs84;
    private boolean doInterpolation;

    public FrenchNTF() {
        this("2e", 1);
    }

    public FrenchNTF(String zone) {
        this(zone, 1);
    }

    public FrenchNTF(int direction) {
        this("2e", direction);
    }

    public FrenchNTF(String zoneText, int direction) {
        this.direction = direction;
        this.clarke1880 = new Ellipsoid(6);
        this.wgs84 = new Ellipsoid(23);
        this.setZone(zoneText);
    }

    public PVector latLongToFrench(PVector p) {
        double rho;
        double phi = (double)p.y * (Math.PI / 180);
        double lamda = (double)p.x * (Math.PI / 180);
        if (Math.abs(Math.abs(phi) - 1.5707963267948966) > 1.0E-10) {
            double slat = Math.sin(phi);
            double es_sin = this.es * slat;
            double t = Math.tan(0.7853981633974483 - phi / 2.0) / Math.pow((1.0 - es_sin) / (1.0 + es_sin), this.esOver2);
            rho = this.aF * Math.pow(t, this.n);
        } else {
            if (phi * this.n <= 0.0) {
                System.err.println("Warning: Cannot project point at lat=" + p.y + " lng=" + p.x);
                return new PVector((float)this.falseEasting, (float)this.falseNorthing);
            }
            rho = 0.0;
        }
        double dlam = lamda - this.lngOrigin;
        double theta = this.n * dlam;
        float easting = (float)(rho * Math.sin(theta) + this.falseEasting);
        float northing = (float)(this.rho0 - rho * Math.cos(theta) + this.falseNorthing);
        return new PVector(easting, northing);
    }

    public PVector frenchToLatLong(PVector p) {
        double lambda;
        double phi;
        double easting = p.x;
        double northing = p.y;
        double tempPhi = 0.0;
        double theta = 0.0;
        double tolerance = 4.85E-10;
        double dy = northing - this.falseNorthing;
        double dx = easting - this.falseEasting;
        double rho0_MINUS_dy = this.rho0 - dy;
        double rho = Math.sqrt(dx * dx + rho0_MINUS_dy * rho0_MINUS_dy);
        if (this.n < 0.0) {
            rho *= -1.0;
            dy *= -1.0;
            dx *= -1.0;
            rho0_MINUS_dy *= -1.0;
        }
        if (rho != 0.0) {
            theta = Math.atan2(dx, rho0_MINUS_dy);
            double t = Math.pow(rho / this.aF, 1.0 / this.n);
            double phiHat = 1.5707963267948966 - 2.0 * Math.atan(t);
            while (Math.abs(phiHat - tempPhi) > tolerance) {
                tempPhi = phiHat;
                double sin_Phi = Math.sin(phiHat);
                double es_sin = this.es * sin_Phi;
                phiHat = 1.5707963267948966 - 2.0 * Math.atan(t * Math.pow((1.0 - es_sin) / (1.0 + es_sin), this.esOver2));
            }
            phi = phiHat;
            lambda = theta / this.n + this.lngOrigin;
            if (Math.abs(phi) < 2.0E-7) {
                phi = 0.0;
            }
            if (phi > 1.5707963267948966) {
                phi = 1.5707963267948966;
            } else if (phi < -1.5707963267948966) {
                phi = -1.5707963267948966;
            }
            if (lambda > Math.PI && lambda - Math.PI < 3.5E-6) {
                lambda = Math.PI;
            }
            if (lambda < -Math.PI && Math.abs(lambda + Math.PI) < 3.5E-6) {
                lambda = -Math.PI;
            }
            if (Math.abs(lambda) < 2.0E-7) {
                lambda = 0.0;
            }
            if (lambda > Math.PI) {
                lambda = Math.PI;
            } else if (lambda < -Math.PI) {
                lambda = -Math.PI;
            }
        } else {
            phi = this.n > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
            lambda = this.lngOrigin;
        }
        float lng = (float)(lambda * 57.29577951308232);
        float lat = (float)(phi * 57.29577951308232);
        return new PVector(lng, lat);
    }

    public PVector transformCoords(PVector p) {
        if (this.direction == 1) {
            return this.latLongToFrench(this.wgs84.projectDatum(p, 6));
        }
        return this.clarke1880.projectDatum(this.frenchToLatLong(p), 23);
    }

    public PVector invTransformCoords(PVector p) {
        if (this.direction == 2) {
            return this.clarke1880.projectDatum(this.latLongToFrench(p), 23);
        }
        return this.frenchToLatLong(this.wgs84.projectDatum(p, 6));
    }

    public String getDescription() {
        if (this.direction == 1) {
            return "Lat/long to French NTF National Grid transformation.";
        }
        return "French NTF National Grid to lat/long transformation.";
    }

    public boolean doInterpolation() {
        return this.doInterpolation;
    }

    public void setInterpolation(boolean doInterpolation) {
        this.doInterpolation = doInterpolation;
    }

    public Ellipsoid getEllipsoid() {
        return this.clarke1880;
    }

    public void setZone(String zoneText) {
        if (zoneText.equals("1")) {
            this.zone = 1;
        } else if (zoneText.equals("2")) {
            this.zone = 2;
        } else if (zoneText.equals("3")) {
            this.zone = 3;
        } else if (zoneText.equals("4")) {
            this.zone = 4;
        } else if (zoneText.equalsIgnoreCase("2e")) {
            this.zone = 5;
        } else {
            System.err.println("Unknown Lambert Zone '" + zoneText + "' provided to FrenchNTF projection. Assuming 'IIe'");
            this.zone = 5;
        }
        switch (this.zone) {
            case 1: {
                this.latOrigin = 0.8639379797371931;
                this.phi1 = 0.879574588185734;
                this.phi2 = 0.848204234116468;
                this.falseEasting = 600000.0;
                this.falseNorthing = 200000.0;
                break;
            }
            case 2: 
            case 5: {
                this.latOrigin = 0.8168140899333461;
                this.phi1 = 0.8324524920567594;
                this.phi2 = 0.801087257736321;
                this.falseEasting = 600000.0;
                this.falseNorthing = 200000.0;
                if (this.zone != 5) break;
                this.falseNorthing = 2200000.0;
                break;
            }
            case 3: {
                this.latOrigin = 0.7696902001294994;
                this.phi1 = 0.7853299889170032;
                this.phi2 = 0.7539698692839378;
                this.falseEasting = 600000.0;
                this.falseNorthing = 200000.0;
                break;
            }
            case 4: {
                this.latOrigin = 0.735918079103409;
                this.phi1 = 0.7464365384929421;
                this.phi2 = 0.7253656051666167;
                this.falseEasting = 234358.0;
                this.falseNorthing = 185861.369;
                break;
            }
            default: {
                System.err.println("Warning: Unknown zone when performing FrenchNTF projection: " + this.zone + ". Assuming II.");
                this.latOrigin = 0.8168140899333461;
                this.phi1 = 0.8324524920567594;
                this.phi2 = 0.801087257736321;
                this.falseEasting = 600000.0;
                this.falseNorthing = 200000.0;
            }
        }
        this.lngOrigin = 0.0407923443377944;
        double a = this.clarke1880.getEquatorialRadius();
        double es2 = this.clarke1880.getSquaredEccentricity();
        this.es = Math.sqrt(es2);
        this.esOver2 = this.es / 2.0;
        double slat = Math.sin(this.latOrigin);
        double es_sin = this.es * slat;
        double t0 = Math.tan(0.7853981633974483 - this.latOrigin / 2.0) / Math.pow((1.0 - es_sin) / (1.0 + es_sin), this.esOver2);
        double slat1 = Math.sin(this.phi1);
        double clat = Math.cos(this.phi1);
        es_sin = this.es * slat1;
        double m1 = clat / Math.sqrt(1.0 - es_sin * es_sin);
        double t1 = Math.tan(0.7853981633974483 - this.phi1 / 2.0) / Math.pow((1.0 - es_sin) / (1.0 + es_sin), this.esOver2);
        slat = Math.sin(this.phi2);
        clat = Math.cos(this.phi2);
        es_sin = this.es * slat;
        double m2 = clat / Math.sqrt(1.0 - es_sin * es_sin);
        double t2 = Math.tan(0.7853981633974483 - this.phi2 / 2.0) / Math.pow((1.0 - es_sin) / (1.0 + es_sin), this.esOver2);
        this.n = Math.log(m1 / m2) / Math.log(t1 / t2);
        double F = m1 / (this.n * Math.pow(t1, this.n));
        this.aF = a * F;
        this.rho0 = t0 == 0.0 && this.n < 0.0 ? 0.0 : this.aF * Math.pow(t0, this.n);
    }

    public int getZoneNumber() {
        switch (this.zone) {
            case 1: {
                return 1;
            }
            case 2: 
            case 5: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
        }
        System.err.println("Unknown French NTF zone. " + this.zone + ". Assuming II");
        return 2;
    }

    public char getZoneLetter() {
        if (this.zone == 5) {
            return 'e';
        }
        return ' ';
    }
}

