/*
 * Decompiled with CFR 0.152.
 */
package org.gicentre.utils.stat;

import java.util.Collection;
import processing.core.PApplet;
import processing.core.PVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardEllipse {
    private PVector centre;
    private PVector wCentre;
    private float majorAxis;
    private float minorAxis;
    private float wMajorAxis;
    private float wMinorAxis;
    private PVector a1;
    private PVector a2;
    private PVector b1;
    private PVector b2;
    private PVector wa1;
    private PVector wa2;
    private PVector wb1;
    private PVector wb2;
    private float rotation;
    private float wRotation;
    private float axisScale;
    private boolean useWeights;
    private static final double DEG2RAD = Math.PI / 180;
    private static final double RAD2DEG = 57.29577951308232;

    public StandardEllipse(PVector centre, float major, float minor, float rotation) {
        this.centre = centre;
        this.wCentre = centre;
        this.majorAxis = major;
        this.wMajorAxis = major;
        this.minorAxis = minor;
        this.wMinorAxis = minor;
        this.rotation = rotation;
        this.wRotation = rotation;
        this.axisScale = 1.0f;
        this.useWeights = false;
        this.calcEndpoints();
    }

    public StandardEllipse(Collection<PVector> points) {
        this(points, false);
    }

    public StandardEllipse(Collection<PVector> points, boolean isLatLong) {
        this.axisScale = 1.0f;
        this.useWeights = false;
        if (points == null || points.size() < 1) {
            this.centre = new PVector(0.0f, 0.0f);
            this.wCentre = new PVector(0.0f, 0.0f);
            this.majorAxis = 0.0f;
            this.wMajorAxis = 0.0f;
            this.minorAxis = 0.0f;
            this.wMinorAxis = 0.0f;
            this.rotation = 0.0f;
            this.wRotation = 0.0f;
            this.calcEndpoints();
            return;
        }
        if (isLatLong) {
            this.calcAxesFromLatLong(points);
        } else {
            this.calcAxesFromPoints(points);
        }
    }

    public void setIsWeighted(boolean weighted) {
        this.useWeights = weighted;
    }

    public boolean isWeighted() {
        return this.useWeights;
    }

    public PVector getCentre() {
        if (this.useWeights) {
            return this.wCentre;
        }
        return this.centre;
    }

    public float getMajorAxis() {
        if (this.useWeights) {
            return this.wMajorAxis;
        }
        return this.majorAxis;
    }

    public float getMinorAxis() {
        if (this.useWeights) {
            return this.wMinorAxis;
        }
        return this.minorAxis;
    }

    public float getRotation() {
        if (this.useWeights) {
            return this.wRotation;
        }
        return this.rotation;
    }

    public PVector getMajorEndpoint1() {
        if (this.useWeights) {
            return this.wa1;
        }
        return this.a1;
    }

    public PVector getMajorEndpoint2() {
        if (this.useWeights) {
            return this.wa2;
        }
        return this.a2;
    }

    public PVector getMinorEndpoint1() {
        if (this.useWeights) {
            return this.wb1;
        }
        return this.b1;
    }

    public PVector getMinorEndpoint2() {
        if (this.useWeights) {
            return this.wb2;
        }
        return this.b2;
    }

    public float getScale() {
        return this.axisScale;
    }

    public void setScale(float axisScale) {
        this.axisScale = axisScale;
        this.calcEndpoints();
    }

    public void draw(PApplet sketch) {
        sketch.pushMatrix();
        if (this.useWeights) {
            sketch.translate(this.wCentre.x, this.wCentre.y);
            sketch.rotate(-this.wRotation);
            sketch.ellipse(0.0f, 0.0f, this.wMajorAxis * this.axisScale, this.wMinorAxis * this.axisScale);
        } else {
            sketch.translate(this.centre.x, this.centre.y);
            sketch.rotate(-this.rotation);
            sketch.ellipse(0.0f, 0.0f, this.majorAxis * this.axisScale, this.minorAxis * this.axisScale);
        }
        sketch.popMatrix();
    }

    public void drawAxes(PApplet sketch) {
        if (this.useWeights) {
            sketch.line(this.wa1.x, this.wa1.y, this.wa2.x, this.wa2.y);
            sketch.line(this.wb1.x, this.wb1.y, this.wb2.x, this.wb2.y);
        } else {
            sketch.line(this.a1.x, this.a1.y, this.a2.x, this.a2.y);
            sketch.line(this.b1.x, this.b1.y, this.b2.x, this.b2.y);
        }
    }

    private void calcAxesFromPoints(Collection<PVector> points) {
        float temp;
        float xTotal = 0.0f;
        float yTotal = 0.0f;
        float weightTotal = 0.0f;
        for (PVector p : points) {
            xTotal += p.x;
            yTotal += p.y;
        }
        this.centre = new PVector(xTotal / (float)points.size(), yTotal / (float)points.size());
        weightTotal = 0.0f;
        xTotal = 0.0f;
        yTotal = 0.0f;
        for (PVector p : points) {
            float weight = 1.0f;
            if (p.z > 0.0f) {
                weight = p.z;
            }
            xTotal += p.x * weight;
            yTotal += p.y * weight;
            weightTotal += weight;
        }
        this.wCentre = new PVector(xTotal / weightTotal, yTotal / weightTotal);
        double sumXSq = 0.0;
        double sumYSq = 0.0;
        double sumXY = 0.0;
        for (PVector p : points) {
            sumXSq += (double)((p.x - this.centre.x) * (p.x - this.centre.x));
            sumYSq += (double)((p.y - this.centre.y) * (p.y - this.centre.y));
            sumXY += (double)((p.x - this.centre.x) * (p.y - this.centre.y));
        }
        double tanAlpha = (sumXSq - sumYSq + Math.sqrt((sumXSq - sumYSq) * (sumXSq - sumYSq) + 4.0 * sumXY * sumXY)) / (2.0 * sumXY);
        this.rotation = (float)Math.atan(tanAlpha);
        if (Double.isNaN(this.rotation)) {
            this.rotation = 0.0f;
        }
        double sinAlpha = Math.sin(this.rotation);
        double cosAlpha = Math.cos(this.rotation);
        this.majorAxis = 2.0f * (float)Math.sqrt((sumXSq * cosAlpha * cosAlpha - 2.0 * sumXY * sinAlpha * cosAlpha + sumYSq * sinAlpha * sinAlpha) / (double)points.size());
        if (Double.isNaN(this.majorAxis)) {
            this.majorAxis = 0.0f;
        }
        this.minorAxis = 2.0f * (float)Math.sqrt((sumXSq * sinAlpha * sinAlpha + 2.0 * sumXY * sinAlpha * cosAlpha + sumYSq * cosAlpha * cosAlpha) / (double)points.size());
        if (Double.isNaN(this.minorAxis)) {
            this.minorAxis = 0.0f;
        }
        if (this.majorAxis < this.minorAxis) {
            temp = this.majorAxis;
            this.majorAxis = this.minorAxis;
            this.minorAxis = temp;
            this.rotation = (this.rotation + 1.5707964f) % ((float)Math.PI * 2);
        }
        sumXSq = 0.0;
        sumYSq = 0.0;
        sumXY = 0.0;
        for (PVector p : points) {
            float weight = 1.0f;
            if (p.z > 0.0f) {
                weight = p.z;
            }
            sumXSq += (double)(weight * (p.x - this.wCentre.x) * (p.x - this.wCentre.x));
            sumYSq += (double)(weight * (p.y - this.wCentre.y) * (p.y - this.wCentre.y));
            sumXY += (double)(weight * (p.x - this.wCentre.x) * (p.y - this.wCentre.y));
        }
        tanAlpha = (sumXSq - sumYSq + Math.sqrt((sumXSq - sumYSq) * (sumXSq - sumYSq) + 4.0 * sumXY * sumXY)) / (2.0 * sumXY);
        this.wRotation = (float)Math.atan(tanAlpha);
        if (Double.isNaN(this.wRotation)) {
            this.wRotation = 0.0f;
        }
        sinAlpha = Math.sin(this.wRotation);
        cosAlpha = Math.cos(this.wRotation);
        this.wMajorAxis = 2.0f * (float)Math.sqrt((sumXSq * cosAlpha * cosAlpha - 2.0 * sumXY * sinAlpha * cosAlpha + sumYSq * sinAlpha * sinAlpha) / (double)weightTotal);
        if (Double.isNaN(this.wMajorAxis)) {
            this.wMajorAxis = 0.0f;
        }
        this.wMinorAxis = 2.0f * (float)Math.sqrt((sumXSq * sinAlpha * sinAlpha + 2.0 * sumXY * sinAlpha * cosAlpha + sumYSq * cosAlpha * cosAlpha) / (double)weightTotal);
        if (Double.isNaN(this.wMinorAxis)) {
            this.wMinorAxis = 0.0f;
        }
        if (this.wMajorAxis < this.wMinorAxis) {
            temp = this.wMajorAxis;
            this.wMajorAxis = this.wMinorAxis;
            this.wMinorAxis = temp;
            this.wRotation = (this.wRotation + 1.5707964f) % ((float)Math.PI * 2);
        }
        this.calcEndpoints();
    }

    private void calcAxesFromLatLong(Collection<PVector> points) {
        float temp;
        double sinComp = 0.0;
        double cosComp = 0.0;
        double latTotal = 0.0;
        double weightTotal = 0.0;
        for (PVector p : points) {
            if (p.x < -180.0f || p.x > 180.0f) {
                System.err.println("Warning: longitude falls outside the range +-180: " + p.x);
            }
            if (p.y < -90.0f || p.y > 90.0f) {
                System.err.println("Warning: latitude falls outside the range +-90: " + p.y);
            }
            sinComp += Math.sin((double)p.x * (Math.PI / 180));
            cosComp += Math.cos((double)p.x * (Math.PI / 180));
            latTotal += (double)p.y;
        }
        this.centre = new PVector((float)(57.29577951308232 * Math.atan2(sinComp, cosComp)), (float)(latTotal / (double)points.size()));
        weightTotal = 0.0;
        sinComp = 0.0;
        cosComp = 0.0;
        latTotal = 0.0;
        for (PVector p : points) {
            float weight = 1.0f;
            if (p.z > 0.0f) {
                weight = p.z;
            }
            sinComp += Math.sin((double)p.x * (Math.PI / 180)) * (double)weight;
            cosComp += Math.cos((double)p.x * (Math.PI / 180)) * (double)weight;
            latTotal += (double)(p.y * weight);
            weightTotal += (double)weight;
        }
        this.wCentre = new PVector((float)(57.29577951308232 * Math.atan2(sinComp, cosComp)), (float)(latTotal / weightTotal));
        double sumXSq = 0.0;
        double sumYSq = 0.0;
        double sumXY = 0.0;
        for (PVector p : points) {
            float smallestLong = (p.x + 180.0f - (this.centre.x + 180.0f)) % 360.0f;
            if (Math.abs(smallestLong) > 180.0f) {
                smallestLong = 360.0f - Math.abs(smallestLong);
            }
            sumXSq += (double)(smallestLong * smallestLong);
            sumYSq += (double)((p.y - this.centre.y) * (p.y - this.centre.y));
            sumXY += (double)(smallestLong * (p.y - this.centre.y));
        }
        double tanAlpha = (sumXSq - sumYSq + Math.sqrt((sumXSq - sumYSq) * (sumXSq - sumYSq) + 4.0 * sumXY * sumXY)) / (2.0 * sumXY);
        this.rotation = (float)Math.atan(tanAlpha);
        if (Double.isNaN(this.rotation)) {
            this.rotation = 0.0f;
        }
        double sinAlpha = Math.sin(this.rotation);
        double cosAlpha = Math.cos(this.rotation);
        this.majorAxis = 2.0f * (float)Math.sqrt((sumXSq * cosAlpha * cosAlpha - 2.0 * sumXY * sinAlpha * cosAlpha + sumYSq * sinAlpha * sinAlpha) / (double)points.size());
        if (Double.isNaN(this.majorAxis)) {
            this.majorAxis = 0.0f;
        }
        this.minorAxis = 2.0f * (float)Math.sqrt((sumXSq * sinAlpha * sinAlpha + 2.0 * sumXY * sinAlpha * cosAlpha + sumYSq * cosAlpha * cosAlpha) / (double)points.size());
        if (Double.isNaN(this.minorAxis)) {
            this.minorAxis = 0.0f;
        }
        if (this.majorAxis < this.minorAxis) {
            temp = this.majorAxis;
            this.majorAxis = this.minorAxis;
            this.minorAxis = temp;
            this.rotation = (this.rotation + 1.5707964f) % ((float)Math.PI * 2);
        }
        sumXSq = 0.0;
        sumYSq = 0.0;
        sumXY = 0.0;
        for (PVector p : points) {
            float smallestLong;
            float weight = 1.0f;
            if (p.z > 0.0f) {
                weight = p.z;
            }
            if (Math.abs(smallestLong = (p.x + 180.0f - (this.centre.x + 180.0f)) % 360.0f) > 180.0f) {
                smallestLong = 360.0f - Math.abs(smallestLong);
            }
            sumXSq += (double)(weight * (smallestLong * smallestLong));
            sumYSq += (double)(weight * ((p.y - this.centre.y) * (p.y - this.centre.y)));
            sumXY += (double)(weight * (smallestLong * (p.y - this.centre.y)));
        }
        tanAlpha = (sumXSq - sumYSq + Math.sqrt((sumXSq - sumYSq) * (sumXSq - sumYSq) + 4.0 * sumXY * sumXY)) / (2.0 * sumXY);
        this.wRotation = (float)Math.atan(tanAlpha);
        if (Double.isNaN(this.wRotation)) {
            this.wRotation = 0.0f;
        }
        sinAlpha = Math.sin(this.wRotation);
        cosAlpha = Math.cos(this.wRotation);
        this.wMajorAxis = 2.0f * (float)Math.sqrt((sumXSq * cosAlpha * cosAlpha - 2.0 * sumXY * sinAlpha * cosAlpha + sumYSq * sinAlpha * sinAlpha) / weightTotal);
        if (Double.isNaN(this.wMajorAxis)) {
            this.wMajorAxis = 0.0f;
        }
        this.wMinorAxis = 2.0f * (float)Math.sqrt((sumXSq * sinAlpha * sinAlpha + 2.0 * sumXY * sinAlpha * cosAlpha + sumYSq * cosAlpha * cosAlpha) / weightTotal);
        if (Double.isNaN(this.wMinorAxis)) {
            this.wMinorAxis = 0.0f;
        }
        if (this.wMajorAxis < this.wMinorAxis) {
            temp = this.wMajorAxis;
            this.wMajorAxis = this.wMinorAxis;
            this.wMinorAxis = temp;
            this.wRotation = (this.wRotation + 1.5707964f) % ((float)Math.PI * 2);
        }
        this.calcEndpoints();
    }

    private void calcEndpoints() {
        float x = (float)((double)(this.axisScale * this.majorAxis) * Math.cos(-this.rotation) / 2.0);
        float y = (float)((double)(this.axisScale * this.majorAxis) * Math.sin(-this.rotation) / 2.0);
        this.a1 = new PVector(x, y);
        this.a2 = new PVector(-x, -y);
        this.a1.add(this.centre);
        this.a2.add(this.centre);
        x = (float)((double)(this.axisScale * this.minorAxis) * Math.sin(this.rotation) / 2.0);
        y = (float)((double)(this.axisScale * this.minorAxis) * Math.cos(this.rotation) / 2.0);
        this.b1 = new PVector(x, y);
        this.b2 = new PVector(-x, -y);
        this.b1.add(this.centre);
        this.b2.add(this.centre);
        x = (float)((double)(this.axisScale * this.wMajorAxis) * Math.cos(-this.wRotation) / 2.0);
        y = (float)((double)(this.axisScale * this.wMajorAxis) * Math.sin(-this.wRotation) / 2.0);
        this.wa1 = new PVector(x, y);
        this.wa2 = new PVector(-x, -y);
        this.wa1.add(this.wCentre);
        this.wa2.add(this.wCentre);
        x = (float)((double)(this.axisScale * this.wMinorAxis) * Math.sin(this.wRotation) / 2.0);
        y = (float)((double)(this.axisScale * this.wMinorAxis) * Math.cos(this.wRotation) / 2.0);
        this.wb1 = new PVector(x, y);
        this.wb2 = new PVector(-x, -y);
        this.wb1.add(this.wCentre);
        this.wb2.add(this.wCentre);
    }
}

