/*
 * Decompiled with CFR 0.152.
 */
package org.gicentre.utils.colour;

import java.awt.Color;

public class ColourConverter {
    static final double[][] M_INV = new double[][]{{3.2406, -1.5372, -0.4986}, {-0.9689, 1.8758, 0.0415}, {0.0557, -0.204, 1.057}};
    static final double[][] M = new double[][]{{0.4124, 0.3576, 0.1805}, {0.2126, 0.7152, 0.0722}, {0.0193, 0.1192, 0.9505}};
    static final double DEG2RAD = 0.017453293;
    static final double RAD2DEG = 57.29577951;

    private ColourConverter() {
    }

    public static double[] getLab(Color colour, WhitePoint wp) {
        return ColourConverter.XYZtoLAB(ColourConverter.RGBtoXYZ(colour), wp);
    }

    public static double[] getLuv(Color colour, WhitePoint wp) {
        return ColourConverter.XYZtoLuv(ColourConverter.RGBtoXYZ(colour), wp);
    }

    public static double[] labToRGB(double L, double a, double b, WhitePoint wp) {
        double[] Lab = new double[]{L, a, b};
        return ColourConverter.XYZtoRGB(ColourConverter.LABtoXYZ(Lab, wp));
    }

    public static double[] luvToRGB(double L, double u, double v, WhitePoint wp) {
        double[] Luv = new double[]{L, u, v};
        return ColourConverter.XYZtoRGB(ColourConverter.LuvToXYZ(Luv, wp));
    }

    static double[] XYZtoRGB(double[] XYZ) {
        double x = XYZ[0] / 100.0;
        double y = XYZ[1] / 100.0;
        double z = XYZ[2] / 100.0;
        double r = x * M_INV[0][0] + y * M_INV[0][1] + z * M_INV[0][2];
        double g = x * M_INV[1][0] + y * M_INV[1][1] + z * M_INV[1][2];
        double b = x * M_INV[2][0] + y * M_INV[2][1] + z * M_INV[2][2];
        r = r > 0.0031308 ? 1.055 * Math.pow(r, 0.4166666667) - 0.055 : (r *= 12.92);
        g = g > 0.0031308 ? 1.055 * Math.pow(g, 0.4166666667) - 0.055 : (g *= 12.92);
        b = b > 0.0031308 ? 1.055 * Math.pow(b, 0.4166666667) - 0.055 : (b *= 12.92);
        return new double[]{r, g, b};
    }

    static double[] LABtoXYZ(double[] Lab, WhitePoint wp) {
        double y = (Lab[0] + 16.0) / 116.0;
        double y3 = Math.pow(y, 3.0);
        double x = Lab[1] / 500.0 + y;
        double x3 = Math.pow(x, 3.0);
        double z = y - Lab[2] / 200.0;
        double z3 = Math.pow(z, 3.0);
        y = y3 > 0.008856 ? y3 : (y - 0.13793103448275862) / 7.787;
        x = x3 > 0.008856 ? x3 : (x - 0.13793103448275862) / 7.787;
        z = z3 > 0.008856 ? z3 : (z - 0.13793103448275862) / 7.787;
        double[] result = new double[]{x * wp.getTristimulus()[0], y * wp.getTristimulus()[1], z * wp.getTristimulus()[2]};
        return result;
    }

    static double[] RGBtoXYZ(Color colour) {
        double r = (double)colour.getRed() / 255.0;
        double g = (double)colour.getGreen() / 255.0;
        double b = (double)colour.getBlue() / 255.0;
        return ColourConverter.RGBtoXYZ(new double[]{r, g, b});
    }

    static double[] RGBtoXYZ(double[] rgb) {
        double r = rgb[0];
        double g = rgb[1];
        double b = rgb[2];
        r = r <= 0.04045 ? (r /= 12.92) : Math.pow((r + 0.055) / 1.055, 2.4);
        g = g <= 0.04045 ? (g /= 12.92) : Math.pow((g + 0.055) / 1.055, 2.4);
        b = b <= 0.04045 ? (b /= 12.92) : Math.pow((b + 0.055) / 1.055, 2.4);
        double[] result = new double[]{(r *= 100.0) * M[0][0] + (g *= 100.0) * M[0][1] + (b *= 100.0) * M[0][2], r * M[1][0] + g * M[1][1] + b * M[1][2], r * M[2][0] + g * M[2][1] + b * M[2][2]};
        return result;
    }

    static double[] XYZtoLuv(double[] XYZ, WhitePoint wp) {
        double xn = wp.getTristimulus()[0];
        double yn = wp.getTristimulus()[1];
        double zn = wp.getTristimulus()[2];
        double y = XYZ[1] / yn;
        double unPrime = 4.0 * xn / (xn + 15.0 * yn + 3.0 * zn);
        double vnPrime = 9.0 * yn / (xn + 15.0 * yn + 3.0 * zn);
        double uPrime = 4.0 * XYZ[0] / (XYZ[0] + 15.0 * XYZ[1] + 3.0 * XYZ[2]);
        double vPrime = 9.0 * XYZ[1] / (XYZ[0] + 15.0 * XYZ[1] + 3.0 * XYZ[2]);
        double L = y > 0.008856452 ? 116.0 * Math.pow(y, 0.3333333333333) - 16.0 : 903.2962963 * y;
        double u = 13.0 * L * (uPrime - unPrime);
        double v = 13.0 * L * (vPrime - vnPrime);
        return new double[]{L, u, v};
    }

    static double[] LuvToXYZ(double[] Luv, WhitePoint wp) {
        double xn = wp.getTristimulus()[0];
        double yn = wp.getTristimulus()[1];
        double zn = wp.getTristimulus()[2];
        double unPrime = 4.0 * xn / (xn + 15.0 * yn + 3.0 * zn);
        double vnPrime = 9.0 * yn / (xn + 15.0 * yn + 3.0 * zn);
        double uPrime = Luv[1] / (13.0 * Luv[0]) + unPrime;
        double vPrime = Luv[2] / (13.0 * Luv[0]) + vnPrime;
        double Y = Luv[0] <= 8.0 ? yn * Luv[0] * 0.001107056 : yn * ((Luv[0] + 16.0) / 116.0) * ((Luv[0] + 16.0) / 116.0) * ((Luv[0] + 16.0) / 116.0);
        double X = Y * (9.0 * uPrime / (4.0 * vPrime));
        double Z = Y * ((12.0 - 3.0 * uPrime - 20.0 * vPrime) / (4.0 * vPrime));
        return new double[]{X, Y, Z};
    }

    static double[] RGBToHSL(double[] rgb) {
        double s;
        double max;
        double min;
        double h = 0.0;
        if (rgb[0] > rgb[1]) {
            min = rgb[1];
            max = rgb[0];
        } else {
            min = rgb[0];
            max = rgb[1];
        }
        if (rgb[2] > max) {
            max = rgb[2];
        }
        if (rgb[2] < min) {
            min = rgb[2];
        }
        double range = max - min;
        double l = (max + min) / 2.0;
        if (range == 0.0) {
            h = 0.0;
            s = 0.0;
        } else {
            s = l < 0.5 ? range / (2.0 * l) : range / (2.0 - 2.0 * l);
            double delR = ((max - rgb[0]) / 6.0 + range / 2.0) / range;
            double delG = ((max - rgb[1]) / 6.0 + range / 2.0) / range;
            double delB = ((max - rgb[2]) / 6.0 + range / 2.0) / range;
            if (rgb[0] == max) {
                h = delB - delG;
            } else if (rgb[1] == max) {
                h = 0.3333333333333333 + delR - delB;
            } else if (rgb[2] == max) {
                h = 0.6666666666666666 + delG - delR;
            }
            if (h < 0.0) {
                h += 1.0;
            }
            if (h > 1.0) {
                h -= 1.0;
            }
        }
        return new double[]{h * 360.0, s, l};
    }

    static double[] HSLToRGB(double[] hsl) {
        double[] rgb = new double[3];
        double q = hsl[2] < 0.5 ? hsl[2] * (1.0 + hsl[1]) : hsl[2] + hsl[1] - hsl[2] * hsl[1];
        double p = 2.0 * hsl[2] * q;
        double hk = hsl[0] / 360.0;
        double tR = hk + 0.3333333333333333;
        double tG = hk;
        double tB = hk - 0.3333333333333333;
        if (tR < 0.0) {
            tR += 1.0;
        } else if (tR > 1.0) {
            tR -= 1.0;
        }
        rgb[0] = tR < 0.16666666666666666 ? p + (q - p) * 6.0 * tR : (tR < 0.5 ? q : (tR < 0.6666666666666666 ? p + (q - p) * 6.0 * (0.6666666666666666 - tR) : p));
        if (tG < 0.0) {
            tG += 1.0;
        } else if (tG > 1.0) {
            tG -= 1.0;
        }
        rgb[1] = tG < 0.16666666666666666 ? p + (q - p) * 6.0 * tG : (tG < 0.5 ? q : (tG < 0.6666666666666666 ? p + (q - p) * 6.0 * (0.6666666666666666 - tG) : p));
        if (tB < 0.0) {
            tB += 1.0;
        } else if (tB > 1.0) {
            tB -= 1.0;
        }
        rgb[2] = tB < 0.16666666666666666 ? p + (q - p) * 6.0 * tB : (tB < 0.5 ? q : (tB < 0.6666666666666666 ? p + (q - p) * 6.0 * (0.6666666666666666 - tB) : p));
        return rgb;
    }

    static double[] LuvToLCh(double[] Luv) {
        double C = Math.sqrt(Luv[1] * Luv[1] + Luv[2] * Luv[2]);
        double h = (360.0 + 57.29577951 * Math.atan2(Luv[2], Luv[1])) % 360.0;
        return new double[]{Luv[0], C, h};
    }

    static double[] LChToLuv(double[] LCh) {
        double hueRad = LCh[2] * 0.017453293;
        double u = LCh[1] * Math.cos(hueRad);
        double v = LCh[1] * Math.sin(hueRad);
        return new double[]{LCh[0], u, v};
    }

    static double[] XYZtoLAB(double[] XYZ, WhitePoint wp) {
        double x = XYZ[0] / wp.getTristimulus()[0];
        double y = XYZ[1] / wp.getTristimulus()[1];
        double z = XYZ[2] / wp.getTristimulus()[2];
        x = x > 0.008856 ? Math.pow(x, 0.3333333333333333) : 7.787 * x + 0.13793103448275862;
        y = y > 0.008856 ? Math.pow(y, 0.3333333333333333) : 7.787 * y + 0.13793103448275862;
        z = z > 0.008856 ? Math.pow(z, 0.3333333333333333) : 7.787 * z + 0.13793103448275862;
        return new double[]{116.0 * y - 16.0, 500.0 * (x - y), 200.0 * (y - z)};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WhitePoint {
        D50(96.4, 100.0, 82.5),
        D55(95.68, 100.0, 92.14),
        D65(95.04, 100.0, 108.88),
        D75(94.97, 100.0, 122.61),
        C(98.07, 100.0, 118.22);

        private double[] params;

        private WhitePoint(double X, double Y, double Z) {
            this.params = new double[]{X, Y, Z};
        }

        double[] getTristimulus() {
            return this.params;
        }
    }
}

