/*
 * Decompiled with CFR 0.152.
 */
package org.gicentre.utils.gui;

import java.util.ArrayList;
import processing.core.PApplet;
import processing.core.PFont;

public class TextInput {
    private ArrayList<StringBuffer> inputLines;
    private int caretPos;
    private int activeLineNumber;
    private PFont font;
    private float textSize;
    private PApplet parent;
    private static final String NEW_LINE = System.getProperty("line.separator");

    public TextInput(PApplet parent, PFont font, float textSize) {
        this.parent = parent;
        this.font = font;
        this.textSize = textSize;
        this.inputLines = new ArrayList();
        this.inputLines.add(new StringBuffer());
        this.caretPos = 0;
        this.activeLineNumber = 0;
    }

    public void draw(float x, float y) {
        this.parent.pushStyle();
        this.parent.textAlign(37, 101);
        this.parent.textFont(this.font, this.textSize);
        float lineHeight = this.parent.textAscent() + this.parent.textDescent();
        float yPos = y;
        for (StringBuffer line : this.inputLines) {
            this.parent.text(line.toString(), x, yPos);
            yPos += lineHeight;
        }
        String activeLine = this.inputLines.get(this.activeLineNumber).toString();
        yPos = y + (float)this.activeLineNumber * lineHeight;
        this.parent.strokeWeight(0.5f);
        this.parent.stroke(this.parent.g.fillColor);
        float caretX = x + this.parent.textWidth(activeLine.substring(0, this.caretPos));
        this.parent.line(caretX, yPos, caretX, yPos + lineHeight);
        this.parent.popStyle();
    }

    public void keyPressed() {
        if (this.parent.key == '\r' || this.parent.key == '\n') {
            String currentText = this.inputLines.get(this.activeLineNumber).toString();
            String textToSplit = currentText.substring(this.caretPos);
            this.inputLines.remove(this.activeLineNumber);
            this.inputLines.add(this.activeLineNumber, new StringBuffer(currentText.substring(0, this.caretPos)));
            this.caretPos = 0;
            ++this.activeLineNumber;
            this.inputLines.add(this.activeLineNumber, new StringBuffer(textToSplit));
        } else if (this.parent.key == '\b') {
            if (this.caretPos > 0) {
                this.inputLines.get(this.activeLineNumber).deleteCharAt(this.caretPos - 1);
                --this.caretPos;
            } else if (this.activeLineNumber > 0) {
                String textToMerge = this.inputLines.get(this.activeLineNumber).toString();
                this.inputLines.remove(this.activeLineNumber);
                --this.activeLineNumber;
                this.inputLines.get(this.activeLineNumber).append(textToMerge);
                this.caretPos = this.inputLines.get(this.activeLineNumber).length() - textToMerge.length();
            }
        } else if (this.parent.key == '\u007f') {
            if (this.caretPos < this.inputLines.get(this.activeLineNumber).length()) {
                this.inputLines.get(this.activeLineNumber).deleteCharAt(this.caretPos);
            } else if (this.activeLineNumber < this.inputLines.size() - 1) {
                String textToMerge = this.inputLines.get(this.activeLineNumber + 1).toString();
                this.inputLines.remove(this.activeLineNumber + 1);
                this.inputLines.get(this.activeLineNumber).append(textToMerge);
            }
        } else if (this.parent.key == '\uffff') {
            if (this.parent.keyCode == 37) {
                if (this.caretPos > 0) {
                    --this.caretPos;
                } else if (this.activeLineNumber > 0) {
                    --this.activeLineNumber;
                    this.caretPos = this.inputLines.get(this.activeLineNumber).length();
                }
            } else if (this.parent.keyCode == 39) {
                if (this.caretPos < this.inputLines.get(this.activeLineNumber).length()) {
                    ++this.caretPos;
                } else if (this.activeLineNumber < this.inputLines.size() - 1) {
                    ++this.activeLineNumber;
                    this.caretPos = 0;
                }
            }
        } else {
            this.inputLines.get(this.activeLineNumber).insert(this.caretPos, Character.toString(this.parent.key));
            ++this.caretPos;
        }
    }

    public void setText(String text) {
        String textLine = text;
        if (text == null) {
            textLine = new String();
        }
        this.inputLines.clear();
        this.activeLineNumber = 0;
        this.inputLines.add(new StringBuffer(textLine));
        this.caretPos = textLine.length();
    }

    public String getText() {
        StringBuffer output = new StringBuffer();
        int i = 0;
        while (i < this.inputLines.size()) {
            StringBuffer line = this.inputLines.get(i);
            output.append(line);
            if (i < this.inputLines.size() - 1) {
                output.append(NEW_LINE);
            }
            ++i;
        }
        return output.toString();
    }
}

