/*
 * Decompiled with CFR 0.152.
 */
package org.gicentre.utils.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class DOMProcessor {
    private int indent;
    private Document dom;
    private PrintWriter out;
    private Vector<Node> matches;

    public DOMProcessor() {
    }

    public DOMProcessor(Document dom) {
        this.dom = dom;
    }

    public DOMProcessor(String fileName) {
        this.readXML(fileName);
    }

    public DOMProcessor(InputStream inStream) {
        this.readXML(inStream);
    }

    public boolean isEmpty() {
        return this.dom == null;
    }

    public Node addElement(String name) {
        if (this.dom == null) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = null;
            this.indent = 0;
            try {
                db = dbf.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                System.err.println("Problem finding an XML parser:\n" + e);
                return null;
            }
            this.dom = db.getDOMImplementation().createDocument(null, name, null);
            this.dom.setStrictErrorChecking(false);
            return this.dom.getDocumentElement();
        }
        return this.addElement(name, null, this.dom.getDocumentElement());
    }

    public Node addElement(String name, Node existingElement) {
        return this.addElement(name, null, existingElement);
    }

    public Node addElement(String name, String text, Node existingElement) {
        Element newNode = this.dom.createElement(name);
        existingElement.appendChild(newNode);
        if (text != null) {
            Text textNode = this.dom.createTextNode(text);
            newNode.appendChild(textNode);
        }
        return newNode;
    }

    public void renameElement(Node existingElement, String newName) {
        Element newElement = this.dom.createElement(newName);
        NamedNodeMap attrs = existingElement.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            Attr attr2 = (Attr)this.dom.importNode(attrs.item(i), true);
            newElement.getAttributes().setNamedItem(attr2);
            ++i;
        }
        while (existingElement.hasChildNodes()) {
            newElement.appendChild(existingElement.getFirstChild());
        }
        existingElement.getParentNode().replaceChild(newElement, existingElement);
    }

    public static void addAttribute(String name, String value, Node node) {
        if (node.getNodeType() == 1) {
            Element element = (Element)node;
            element.setAttribute(name, value);
        }
    }

    public void addComment(String comment) {
        this.addComment(comment, this.dom.getDocumentElement());
    }

    public void addComment(String comment, Node node) {
        node.getParentNode().insertBefore(this.dom.createComment(comment), node);
    }

    public void addText(String text, Node node) {
        node.appendChild(this.dom.createTextNode(text));
    }

    public String[] getText(String elementName) {
        return this.getText(elementName, this.dom);
    }

    public String[] getText(Node node) {
        return this.getText(null, node);
    }

    public String[] getText(String elementName, Node node) {
        this.matches = new Vector();
        this.searchText(elementName, node);
        String[] matchArray = new String[this.matches.size()];
        int i = 0;
        for (Node matchedNode : this.matches) {
            matchArray[i++] = matchedNode.getNodeValue();
        }
        this.matches = null;
        return matchArray;
    }

    public static String getNodeText(Node node) {
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 4 || child.getNodeType() == 3) {
                return child.getNodeValue();
            }
            ++i;
        }
        return null;
    }

    public String[] getAttributes(String attributeName) {
        return this.getAttributes(attributeName, this.dom);
    }

    public String[] getAttributes(String attributeName, Node node) {
        this.matches = new Vector();
        this.searchAttributes(attributeName, node);
        String[] matchArray = new String[this.matches.size()];
        int i = 0;
        for (Node matchedNode : this.matches) {
            matchArray[i++] = matchedNode.getNodeValue();
        }
        this.matches = null;
        return matchArray;
    }

    public static String getNodeAttribute(String attributeName, Node node) {
        if (node.getNodeType() != 9 && node.getNodeType() != 1) {
            return null;
        }
        NamedNodeMap attributes = node.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Node attribute = attributes.item(i);
            if (attribute.getNodeName().equalsIgnoreCase(attributeName)) {
                return attribute.getNodeValue();
            }
            ++i;
        }
        return null;
    }

    public Node[] getElements(String name) {
        return this.getElements(name, this.dom);
    }

    public Node[] getElements(String name, Node node) {
        this.matches = new Vector();
        this.searchNode(name, node);
        Node[] matchArray = new Node[this.matches.size()];
        this.matches.toArray(matchArray);
        this.matches = null;
        return matchArray;
    }

    public static Node getNodeElement(String name, Node node) {
        if (node.getNodeType() != 9 && node.getNodeType() != 1) {
            return null;
        }
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1 && child.getNodeName().equalsIgnoreCase(name)) {
                return child;
            }
            ++i;
        }
        return null;
    }

    public static Node[] getNodeElements(String name, Node node) {
        if (node.getNodeType() != 9 && node.getNodeType() != 1) {
            return new Node[0];
        }
        Vector<Node> matchedChildren = new Vector<Node>();
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1 && child.getNodeName().equalsIgnoreCase(name)) {
                matchedChildren.add(child);
            }
            ++i;
        }
        Node[] nodes = new Node[matchedChildren.size()];
        matchedChildren.toArray(nodes);
        return nodes;
    }

    public boolean readXML(String fileName) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = null;
        this.indent = 0;
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            System.err.println("Problem finding an XML parser:\n" + e);
            return false;
        }
        try {
            this.dom = db.parse(new File(fileName));
        }
        catch (SAXException e) {
            System.err.println("Problem parsing document: " + e.getMessage());
            this.dom = db.newDocument();
            return false;
        }
        catch (IOException e) {
            System.err.println("Problem reading " + fileName);
            return false;
        }
        return true;
    }

    public boolean readXML(InputStream inStream) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = null;
        this.indent = 0;
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            System.err.println("Problem finding an XML parser:\n" + e);
            return false;
        }
        try {
            this.dom = db.parse(inStream);
        }
        catch (SAXException e) {
            System.err.println("Problem parsing document: " + e.getMessage());
            this.dom = db.newDocument();
            return false;
        }
        catch (IOException e) {
            System.err.println("Problem reading from " + inStream);
            return false;
        }
        return true;
    }

    public boolean writeXML() {
        return this.writeXML(null, null, null);
    }

    public boolean writeXML(String version, String encoding, Boolean standalone) {
        this.out = new PrintWriter(System.out);
        this.indent = 0;
        this.outputNodeAsXML(this.dom, version, encoding, standalone);
        this.out.flush();
        return true;
    }

    public boolean writeXML(String fileName) {
        return this.writeXML(fileName, null, null, null);
    }

    public boolean writeXML(OutputStream outStream) {
        return this.writeXML(outStream, null, null, null);
    }

    public boolean writeXML(String fileName, String version, String encoding, Boolean standalone) {
        if (this.dom == null) {
            System.err.println("Error: No document object model to process.");
            return false;
        }
        try {
            this.out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
        }
        catch (IOException e) {
            System.err.println("Error: Problem creating XML file: " + fileName);
            return false;
        }
        this.indent = 0;
        this.outputNodeAsXML(this.dom, version, encoding, standalone);
        this.out.close();
        return true;
    }

    public boolean writeXML(OutputStream outStream, String version, String encoding, Boolean standalone) {
        if (this.dom == null) {
            System.err.println("Error: No document object model to process.");
            return false;
        }
        this.out = new PrintWriter(outStream);
        this.indent = 0;
        this.outputNodeAsXML(this.dom, version, encoding, standalone);
        this.out.close();
        return true;
    }

    private void searchText(String element, Node node) {
        int i;
        NodeList children;
        if (node.getNodeType() != 9 && node.getNodeType() != 1) {
            return;
        }
        if (element == null || node.getNodeName().equalsIgnoreCase(element)) {
            children = node.getChildNodes();
            i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if ((child.getNodeType() == 4 || child.getNodeType() == 3) && child.getNodeValue().trim().length() > 0) {
                    this.matches.add(child);
                }
                ++i;
            }
        }
        if (node.getNodeType() == 9 || node.getNodeType() == 1) {
            children = node.getChildNodes();
            i = 0;
            while (i < children.getLength()) {
                this.searchText(element, children.item(i));
                ++i;
            }
        }
    }

    private void searchAttributes(String element, Node node) {
        if (node.getNodeType() != 9 && node.getNodeType() != 1) {
            return;
        }
        NamedNodeMap attributes = node.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Node attribute = attributes.item(i);
            if (attribute.getNodeName().equalsIgnoreCase(element)) {
                this.matches.add(attribute);
            }
            ++i;
        }
        NodeList children = node.getChildNodes();
        int i2 = 0;
        while (i2 < children.getLength()) {
            this.searchAttributes(element, children.item(i2));
            ++i2;
        }
    }

    private void searchNode(String element, Node node) {
        if (node.getNodeType() != 9 && node.getNodeType() != 1) {
            return;
        }
        if (node.getNodeName().equalsIgnoreCase(element)) {
            this.matches.add(node);
        }
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            this.searchNode(element, children.item(i));
            ++i;
        }
    }

    private void outputNodeAsXML(Node node) {
        this.outputNodeAsXML(node, null, null, null);
    }

    private void outputNodeAsXML(Node node, String version, String encoding, Boolean standalone) {
        String name = node.getNodeName();
        String value = DOMProcessor.makeFriendly(node.getNodeValue());
        short type = node.getNodeType();
        if (value != null && value.trim().equals("")) {
            return;
        }
        switch (type) {
            case 9: {
                if (version == null) {
                    this.out.print("<?xml version=\"1.0\" ");
                } else {
                    this.out.print("<?xml version=\"" + version + "\" ");
                }
                if (encoding != null) {
                    this.out.print("encoding=\"" + encoding + "\" ");
                }
                if (standalone != null) {
                    if (standalone.booleanValue()) {
                        this.out.print("standalone=\"yes\" ");
                    } else {
                        this.out.print("standalone=\"no\" ");
                    }
                }
                this.out.println("?>");
                NodeList children = node.getChildNodes();
                int i = 0;
                while (i < children.getLength()) {
                    this.outputNodeAsXML(children.item(i));
                    ++i;
                }
                break;
            }
            case 1: {
                ++this.indent;
                this.indent();
                this.out.print("<" + name);
                NamedNodeMap attributes = node.getAttributes();
                int i = 0;
                while (i < attributes.getLength()) {
                    Node attribute = attributes.item(i);
                    this.out.print(" " + attribute.getNodeName() + "=\"" + attribute.getNodeValue() + "\"");
                    ++i;
                }
                this.out.print(">");
                NodeList children = node.getChildNodes();
                int i2 = 0;
                while (i2 < children.getLength()) {
                    this.outputNodeAsXML(children.item(i2));
                    ++i2;
                }
                break;
            }
            case 3: 
            case 4: {
                this.out.print(value);
                break;
            }
            case 8: {
                ++this.indent;
                this.indent();
                this.out.print("<!--" + value + "-->");
                --this.indent;
                break;
            }
            case 5: {
                ++this.indent;
                this.indent();
                this.out.print("&" + name + ";");
                --this.indent;
                break;
            }
            case 7: {
                ++this.indent;
                this.indent();
                this.out.print("<?" + name);
                if (value != null && value.length() > 0) {
                    this.out.print(" " + value);
                }
                this.out.println("?>");
                --this.indent;
                break;
            }
        }
        if (type == 1) {
            this.out.print("</" + node.getNodeName() + ">");
            --this.indent;
            if (node.getNextSibling() == null) {
                this.indent();
            }
        }
    }

    private static String makeFriendly(String text) {
        StringBuffer newText = new StringBuffer();
        if (text == null) {
            return null;
        }
        int numCharacters = text.length();
        int i = 0;
        while (i < numCharacters) {
            char ch = text.charAt(i);
            switch (ch) {
                case '<': {
                    newText.append("&lt;");
                    break;
                }
                case '>': {
                    newText.append("&gt;");
                    break;
                }
                case '&': {
                    newText.append("&amp;");
                    break;
                }
                case '\"': {
                    newText.append("&quot;");
                    break;
                }
                default: {
                    newText.append(ch);
                }
            }
            ++i;
        }
        return newText.toString();
    }

    private void indent() {
        this.out.println("");
        int i = 1;
        while (i < this.indent) {
            this.out.print(" ");
            ++i;
        }
    }
}

