/*
 * Decompiled with CFR 0.152.
 */
package org.gicentre.utils.network.traer.physics;

import org.gicentre.utils.network.traer.physics.BackwardEulerIntegrator;
import org.gicentre.utils.network.traer.physics.ModifiedEulerIntegrator;
import org.gicentre.utils.network.traer.physics.ParticleSystem;
import org.gicentre.utils.network.traer.physics.RungeKuttaIntegrator;
import org.gicentre.utils.network.traer.physics.SettlingRungeKuttaIntegrator;

public abstract class Integrator {
    protected ParticleSystem s;

    public Integrator(ParticleSystem s) {
        this.s = s;
    }

    public abstract Integrator step(float var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum METHOD {
        RUNGEKUTTA{

            public Integrator factory(ParticleSystem physics) {
                return new RungeKuttaIntegrator(physics);
            }
        }
        ,
        EULER{

            public Integrator factory(ParticleSystem physics) {
                return new BackwardEulerIntegrator(physics);
            }
        }
        ,
        MODEULER{

            public Integrator factory(ParticleSystem physics) {
                return new ModifiedEulerIntegrator(physics);
            }
        }
        ,
        SRUNGEKUTTA{

            public Integrator factory(ParticleSystem physics) {
                return new SettlingRungeKuttaIntegrator(physics);
            }
        };


        public abstract Integrator factory(ParticleSystem var1);
    }
}

