/*
 * Decompiled with CFR 0.152.
 */
package org.gicentre.utils.network.traer.physics;

import org.gicentre.utils.geom.Locatable;
import org.gicentre.utils.network.traer.physics.Vector3D;
import processing.core.PVector;

public class Particle
implements Locatable {
    public static final float DEFAULT_MASS = 1.0f;
    protected boolean isFixed = false;
    protected Vector3D position = new Vector3D();
    protected Vector3D velocity = new Vector3D();
    protected float age = 0.0f;
    protected boolean isDead = false;
    private float mass;
    private Vector3D force = new Vector3D();

    public Particle() {
        this(1.0f);
    }

    public Particle(float m) throws IllegalArgumentException {
        this.setMass(m);
    }

    public final float distanceTo(Particle p) throws NullPointerException {
        if (p == null) {
            throw new NullPointerException("The Particle p is null.");
        }
        return this.position().distanceTo(p.position());
    }

    public final Particle makeFixed() {
        return this.setFixed(true);
    }

    public final Particle makeFree() {
        return this.setFixed(false);
    }

    public final Particle setFixed(boolean isFixed) {
        this.isFixed = isFixed;
        if (isFixed) {
            this.velocity.clear();
        }
        return this;
    }

    public final boolean isFixed() {
        return this.isFixed;
    }

    public final boolean isFree() {
        return !this.isFixed();
    }

    public final Vector3D position() {
        return this.position;
    }

    public PVector getLocation() {
        return this.position.getLocation();
    }

    public final Vector3D velocity() {
        return this.velocity;
    }

    public final float mass() {
        return this.mass;
    }

    public final Particle setMass(float m) {
        if (m <= 0.0f) {
            throw new IllegalArgumentException("Particle mass must be greater than 0.  Supplied m: " + m);
        }
        this.mass = m;
        return this;
    }

    @Deprecated
    public final Vector3D force() {
        return this.getForce();
    }

    public final Vector3D getForce() {
        return this.force;
    }

    public final Particle addForce(Vector3D addedForce) {
        this.force.add(addedForce);
        return this;
    }

    public final Particle clearForce() {
        this.force.clear();
        return this;
    }

    public final float age() {
        return this.age;
    }

    public Particle reset() {
        this.age = 0.0f;
        this.isDead = false;
        this.position.clear();
        this.velocity.clear();
        this.force.clear();
        this.mass = 1.0f;
        return this;
    }
}

