/*
 * Decompiled with CFR 0.152.
 */
package org.gicentre.utils.spatial;

import org.gicentre.utils.spatial.Ellipsoid;
import org.gicentre.utils.spatial.MapProjection;
import processing.core.PVector;

public class LambertConformalConic
implements MapProjection {
    private Ellipsoid ellipsoid;
    private boolean doInterpolation;
    private int direction;
    private static final double RAD2DEG = 57.29577951308232;
    private static final double DEG2RAD = Math.PI / 180;
    private static final double PI_OVER_2 = 1.5707963267948966;
    private static final double PI_OVER_4 = 0.7853981633974483;
    public static final int FROM_LAT_LONG = 1;
    public static final int TO_LAT_LONG = 2;
    private double phi1;
    private double phi2;
    private double lngCentre;
    private double falseEast;
    private double falseNorth;
    private double e;
    private double eSq;
    private double cosPhi1;
    private double cosPhi2;
    private double a;
    private double n;
    private double F;
    private double rho0;
    private boolean isSingleParallel;

    public LambertConformalConic(double lat1, double lon0, double lat0) {
        this(new Ellipsoid(99), lat1, lat1, lon0, lat0, 0.0, 0.0);
    }

    public LambertConformalConic(Ellipsoid ellipsoid, double lat1, double lat2, double lon0, double lat0, double falseEast, double falseNorth) {
        this.ellipsoid = ellipsoid;
        this.doInterpolation = true;
        this.direction = 1;
        this.phi1 = lat1 * (Math.PI / 180);
        this.phi2 = lat2 * (Math.PI / 180);
        this.isSingleParallel = Math.abs(this.phi1 - this.phi2) < 1.0E-10;
        this.lngCentre = lon0 * (Math.PI / 180);
        this.falseEast = falseEast;
        this.falseNorth = falseNorth;
        this.eSq = ellipsoid.getSquaredEccentricity();
        this.e = Math.sqrt(this.eSq);
        this.a = ellipsoid.getEquatorialRadius();
        this.cosPhi1 = Math.cos(this.phi1);
        this.cosPhi2 = Math.cos(this.phi2);
        double phi0 = lat0 * (Math.PI / 180);
        double sinPhi0 = Math.sin(phi0);
        double sinPhi1 = Math.sin(this.phi1);
        double sinPhi2 = Math.sin(this.phi2);
        double m1 = this.cosPhi1 / Math.sqrt(1.0 - this.eSq * sinPhi1 * sinPhi1);
        double m2 = this.cosPhi2 / Math.sqrt(1.0 - this.eSq * sinPhi2 * sinPhi2);
        double t0 = Math.tan(0.7853981633974483 - phi0 / 2.0) / Math.pow((1.0 - this.e * sinPhi0) / (1.0 + this.e * sinPhi0), this.e / 2.0);
        double t1 = Math.tan(0.7853981633974483 - this.phi1 / 2.0) / Math.pow((1.0 - this.e * sinPhi1) / (1.0 + this.e * sinPhi1), this.e / 2.0);
        double t2 = Math.tan(0.7853981633974483 - this.phi2 / 2.0) / Math.pow((1.0 - this.e * sinPhi2) / (1.0 + this.e * sinPhi2), this.e / 2.0);
        this.n = this.isSingleParallel ? sinPhi1 : (Math.log(m1) - Math.log(m2)) / (Math.log(t1) - Math.log(t2));
        this.F = m1 / (this.n * Math.pow(t1, this.n));
        this.rho0 = this.a * this.F * Math.pow(t0, this.n);
    }

    public PVector transformCoords(PVector p) {
        if (this.direction == 1) {
            return this.latLongToLambert(p);
        }
        return this.LambertToLatLong(p);
    }

    public PVector invTransformCoords(PVector p) {
        if (this.direction == 1) {
            return this.LambertToLatLong(p);
        }
        return this.latLongToLambert(p);
    }

    public String getDescription() {
        if (this.direction == 1) {
            return "Lat/long to Lambert conformal conic transformation.";
        }
        return "Lambert conformal conic to lat/long transformation.";
    }

    public boolean doInterpolation() {
        return this.doInterpolation;
    }

    public void setInterpolation(boolean doInterpolation) {
        this.doInterpolation = doInterpolation;
    }

    public PVector latLongToLambert(PVector p) {
        double phi = (double)p.y * (Math.PI / 180);
        double lambda = (double)p.x * (Math.PI / 180);
        double sinPhi = Math.sin(phi);
        double t = Math.tan(0.7853981633974483 - phi / 2.0) / Math.pow((1.0 - this.e * sinPhi) / (1.0 + this.e * sinPhi), this.e / 2.0);
        double rho = this.a * this.F * Math.pow(t, this.n);
        double theta = this.n * (lambda - this.lngCentre);
        return new PVector((float)(rho * Math.sin(theta) + this.falseEast), (float)(this.rho0 - rho * Math.cos(theta) + this.falseNorth));
    }

    public PVector LambertToLatLong(PVector p) {
        double easting = (double)p.x - this.falseEast;
        double northing = (double)p.y - this.falseNorth;
        double theta = this.n < 0.0 ? Math.atan(-easting / (northing - this.rho0)) : Math.atan(easting / (this.rho0 - northing));
        double lambda = theta / this.n + this.lngCentre;
        double rho = Math.sqrt(easting * easting + (this.rho0 - northing) * (this.rho0 - northing));
        if (this.n < 0.0) {
            rho *= -1.0;
        }
        double t = Math.pow(rho / (this.a * this.F), 1.0 / this.n);
        double phi = 0.0;
        double phiPrev = 1.5707963267948966 - 2.0 * Math.atan(t);
        double delta = 3.4028234663852886E38;
        while (delta > 0.001) {
            double sinPhi = Math.sin(phiPrev);
            phi = 1.5707963267948966 - 2.0 * Math.atan(t * Math.pow((1.0 - this.e * sinPhi) / (1.0 + this.e * sinPhi), this.e / 2.0));
            delta = Math.abs(phi - phiPrev);
            phiPrev = phi;
        }
        return new PVector((float)(lambda * 57.29577951308232), (float)(phi * 57.29577951308232));
    }

    public Ellipsoid getEllipsoid() {
        return this.ellipsoid;
    }
}

