/*
 * Decompiled with CFR 0.152.
 */
package org.gicentre.utils.spatial;

import org.gicentre.utils.spatial.Ellipsoid;
import org.gicentre.utils.spatial.UTM;
import processing.core.PVector;

public class OSGB
extends UTM {
    private double scaleFactor;
    private double latOrigin;
    private double lngOrigin;
    private double xOffset;
    private double yOffset;
    private int direction;
    private Ellipsoid wgs84 = new Ellipsoid(23);
    private Ellipsoid airy1830 = this.getEllipsoid();

    public OSGB() {
        this(1);
    }

    public OSGB(int direction) {
        super(new Ellipsoid(1), 50.0f, -2.0f);
        this.direction = direction;
        this.scaleFactor = 0.9996012717;
        this.latOrigin = 49.0;
        this.lngOrigin = -2.0;
        this.xOffset = 400000.0;
        this.yOffset = -100000.0;
    }

    public PVector transformCoords(PVector p) {
        if (this.direction == 1) {
            return this.latLongToUTM(this.wgs84.projectDatum(p, 1), this.lngOrigin, this.latOrigin, this.xOffset, this.yOffset, this.scaleFactor);
        }
        return this.airy1830.projectDatum(this.UTMToLatLong(p, this.lngOrigin, this.latOrigin, this.xOffset, this.yOffset, this.scaleFactor), 23);
    }

    public PVector invTransformCoords(PVector p) {
        if (this.direction == 1) {
            return this.airy1830.projectDatum(this.UTMToLatLong(p, this.lngOrigin, this.latOrigin, this.xOffset, this.yOffset, this.scaleFactor), 23);
        }
        return this.latLongToUTM(this.wgs84.projectDatum(p, 1), this.lngOrigin, this.latOrigin, this.xOffset, this.yOffset, this.scaleFactor);
    }

    public String getDescription() {
        if (this.direction == 1) {
            return "Lat/long to Ordnance Survey GB National Grid transformation.";
        }
        return "Ordnance Survey GB National Grid to lat/long transformation.";
    }
}

