/*
 * Decompiled with CFR 0.152.
 */
package org.gicentre.utils.spatial;

import org.gicentre.utils.spatial.Ellipsoid;
import org.gicentre.utils.spatial.MapProjection;
import processing.core.PVector;

public class WebMercator
implements MapProjection {
    public static final int FROM_LAT_LONG = 1;
    public static final int TO_LAT_LONG = 2;
    private static final double RAD2DEG = 57.29577951308232;
    private static final double DEG2RAD = Math.PI / 180;
    private static final double PI_OVER_4 = 0.7853981633974483;
    private static final double PI_OVER_2 = 1.5707963267948966;
    private int direction;
    private Ellipsoid sphere;
    private double R;
    private double lamda0;
    private boolean doInterpolation;

    public WebMercator() {
        this(1);
    }

    public WebMercator(int direction) {
        this.direction = direction;
        this.sphere = new Ellipsoid(99);
        this.R = this.sphere.getEquatorialRadius();
        this.lamda0 = 0.0;
    }

    public PVector latLongToWebMercator(PVector p) {
        if (p.x < -180.0f || p.x > 180.0f) {
            System.err.println("latLongToWebMercator: Longitude out of bounds: " + p.x);
            return null;
        }
        if (p.y < -88.0f || p.y > 88.0f) {
            System.err.println("latLongToWebMercator: Latitude out of bounds: " + p.y);
            return null;
        }
        double phi = (double)p.y * (Math.PI / 180);
        double lamda = (double)p.x * (Math.PI / 180);
        double easting = this.R * (lamda - this.lamda0);
        double northing = this.R * Math.log(Math.tan(0.7853981633974483 + phi / 2.0));
        return new PVector((float)easting, (float)northing);
    }

    public PVector webMercatorToLatLong(PVector p) {
        double easting = p.x;
        double northing = p.y;
        double D = -northing / this.R;
        double lat = 57.29577951308232 * (1.5707963267948966 - 2.0 * Math.atan(Math.exp(D)));
        double lng = 57.29577951308232 * easting / this.R;
        return new PVector((float)lng, (float)lat);
    }

    public PVector transformCoords(PVector p) {
        if (this.direction == 1) {
            return this.latLongToWebMercator(p);
        }
        return this.webMercatorToLatLong(p);
    }

    public PVector invTransformCoords(PVector p) {
        if (this.direction == 2) {
            return this.latLongToWebMercator(p);
        }
        return this.webMercatorToLatLong(p);
    }

    public String getDescription() {
        if (this.direction == 1) {
            return new String("Lat/long to Web Mercator transformation.");
        }
        return new String("Web Mercator to lat/long transformation.");
    }

    public boolean doInterpolation() {
        return this.doInterpolation;
    }

    public void setInterpolation(boolean doInterpolation) {
        this.doInterpolation = doInterpolation;
    }

    public Ellipsoid getEllipsoid() {
        return this.sphere;
    }
}

